unit DemoSownika;

interface

uses
  Generics.Collections;

type
  TSownikOcen = TDictionary<string, double>;

procedure OcenyUczniw;

implementation

uses
  System.SysUtils;

procedure WywietlOceny(aUczniowie: TSownikOcen);
var
  Ucze: string;
begin
  for Ucze in aUczniowie.Keys do
  begin
    WriteLn(Ucze, ', rednia ocena: ', Format('%.2f', [aUczniowie[Ucze]]));
  end;
end;

procedure OcenyUczniw;
var
  SownikOcen: TSownikOcen;
begin
  SownikOcen := TSownikOcen.Create;
  try
    // Wpisanie ocen uczniw
    SownikOcen.Add('Staszek Mistrz', 4.0);
    SownikOcen.Add('Heniek Kujon', 3.73);
    SownikOcen.Add('Andrzej redniak', 2.55);
    SownikOcen.Add('Franek Le', 1.01);

    // Wywietlenie ocen uczniw
    WywietlOceny(SownikOcen);
    WriteLn;

    WriteLn('Ojej, bd w obliczeniach!');
    SownikOcen['Andrzej redniak'] := 2.62;
    SownikOcen['Heniek Kujon'] := 3.70;
    // Wywietlenie ocen uczniw
    WywietlOceny(SownikOcen);
    WriteLn;
  finally
    SownikOcen.Free;
  end;
end;

end.

